<?php
namespace lib;

require \Pawn::helper('validation');

class Field
{
	public $name, $value, $error_message = false;
	protected $validation, $form = false;
	
	# Value
	public function __toString()
	{
		return $this->value;
	}
	
	public function setValue($value)
	{
		$this->value = $value;
	}
	
	# Form
	public function child_of($form)
	{
		$this->form = $form;
		
		if($form->submitted)
		{
			$this->setValue($form->request($this->name));
		}
	}
	
	# Validate
	public function validate()
	{
		if(isset($this->validation['optional']))
		{
			if($this->validation['optional'])
			{
				if($this->value === '')
				{
					return true;
				}
			} elseif($this->value === '')
			{
				return $this->set_error('optional');
			}
			
			unset($this->validation['optional']);
		}
		
		foreach($this->validation as $key=>$value)
		{
			if(substr($key, 0, 2) == 'c_')
			{
				$fn = $value;
				$value = null;
				$custom = true;
			} else
			{
				$fn = $key;
				$custom = false;
			}
			
			if(!call_user_func_array($fn, array(($this->type == 'file')?$this:$this->value, $value, $this->form)))
			{
				return $this->set_error($key, $custom?null:$value);
			}
		}
		
		return true;
	}
	
	# Lang
	private function lang($key)
	{
		return $this->form?\lib\Lang::find($this->form->name, $key):\lib\Lang::find($key);
	}
	
	# Label
	public function label()
	{
		return $this->lang($this->name);
	}
	
	# Error
	public function error($message=null)
	{
		if($message !== null)
		{
			$this->error_message = $message;
		}
		
		return $this->error_message;
	}
	
	public function set_error($key, $value=null)
	{
		if($this->form)
		{
			if($this->error_message = \lib\Lang::get($this->form->name, 'error', $this->name, $key, $value))
			{
				return false;
			}
			
			if($this->error_message = \lib\Lang::get($this->form->name, 'error', $key, $value))
			{
				return false;
			}
		}
		
		$response = \lib\Lang::get('error', $key, $value);
		
		$this->error_message = $response?$response:$key;
		
		return false;
	}
}